function [RecInfo] = LoadExperimentalData(Inputfile)
%Load a comma separated datafile with one header line and data organised in
%records with record descriptors (e.g, experiment, latitude, longitude, year, month, day) in the first few columns
%
%Function usage:
% [RecInfo] = LoadExperimentalData(Inputfile)
%
%Inputs: filename of comma separated file including path and extension 
%
%Outputs: structure with record info
%  elements: Var,
%      INPUTFILE: path and name of inputfile used
%    StringNames: headername of text descriptors of records
%       NumNames: headername of numerical descriptors of records
%       VarNames: names of variables in records
%         String: text descriptors of records
%            Num: numerical descriptors of records
%            Var: value of variables in records
%       NRecords: number of records
%Dr A.G.T Schut 2015, Wageningen University

%constants
INVAL_INDICATOR=-9999;        %Value for missing data
N_STRING_SITE_DESCRIPTORS =2; %Number of columns with text describing the record
N_NUM_SITE_DESCRIPTORS = 4;   %Total number of columns describing the record (so including text-columns)

%=================LOADING RAW DATA=========================================
n_site_descriptors = N_NUM_SITE_DESCRIPTORS  + N_STRING_SITE_DESCRIPTORS;
 
%read headerline
fid=fopen(Inputfile);line=fgetl(fid);fclose(fid);
header=strread(line,'%s','delimiter',',');
%define number of variables
nvar=length(header)-n_site_descriptors;

%extract names of variables from the header line
RecInfo.INPUTFILE=Inputfile;
RecInfo.StringNames=header(1:N_STRING_SITE_DESCRIPTORS);
RecInfo.NumNames=header(N_STRING_SITE_DESCRIPTORS+1:n_site_descriptors);
RecInfo.VarNames=header(n_site_descriptors+1:n_site_descriptors+nvar);

%Define format how to read the data with strings and floating point numbers
fstr=[repmat('%s ',1,N_STRING_SITE_DESCRIPTORS) repmat('%f ',1,N_NUM_SITE_DESCRIPTORS) repmat('%f ',1,nvar)];

%Read in the actual data from the file
[RecInfo.String{1:N_STRING_SITE_DESCRIPTORS}, RecInfo.Num{1:N_NUM_SITE_DESCRIPTORS}, RecInfo.Var{1:nvar}]= ...
    textread(Inputfile,fstr,'headerlines',1,'delimiter',',');
%convert cells to one matrix!
RecInfo.Num=cell2mat(RecInfo.Num);
RecInfo.Var=cell2mat(RecInfo.Var);

%convert invalid number to a NaN
a=logical(RecInfo.Var==INVAL_INDICATOR);
RecInfo.Var(a)=NaN;
RecInfo.NRecords = size(RecInfo.Num,1);

return
